<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="createDestructorSummaryTable">
		<xsl:param name="title"/>
		<xsl:param name="nodeSet"/>
		<xsl:param name="classpath"/>
		<a name="destructor_summary"></a>
		<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<tr class="TableHeaderStyle">
				<td colspan="2">
					<font size="+2">
						<b>
							<xsl:value-of select="$title"/>
						</b>
					</font>
				</td>
			</tr>
			<xsl:for-each select="$nodeSet">
				<xsl:sort select="@elementName" />
				<xsl:variable name="description">
					<xsl:apply-templates select="current()" mode="getDescription"/>
				</xsl:variable>
				<xsl:variable name="elName" select="@name"/>
				<xsl:variable name="inner-ref">
					<xsl:apply-templates select="current()" mode="method-ref"></xsl:apply-templates>
				</xsl:variable>
				<tr class="TableRow">
					<td>
						<code><b>
							<a href="{$classpath}#{$inner-ref}">
								<xsl:value-of select="$elName"/>
							</a></b>
							<xsl:apply-templates select="current()" mode="method-parentheses"></xsl:apply-templates>
						</code>
						<br/><xsl:text>&#x9;</xsl:text>
						<xsl:choose>
							<xsl:when test="string-length($description) &gt; 0">
								<xsl:value-of select="Property[@name='description']"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>&#xA0;</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</xsl:for-each>
		</table>
		<xsl:text>&#xA0;</xsl:text>
		<p/>
	</xsl:template>
</xsl:stylesheet>
